<?php

class DiskRepository {

	function addNewDisk(DiskConfiguration $conf) {
		$newDisk = new Disk($conf->getSize());
		$newDisk->computeSectorsBaseOnBlockSize($conf->getBlockSize());
		$newDisk->applyCylinders($this->computeCylinders($conf));
		$newDisk->setQuotaForReservation($conf->getQuota(), $conf->getReservation());

		$this->applyChangesToSystem($newDisk);
	}

	private function applyChangesToSystem($newDisk) {
		// some logic to apply the changes
	}

	private function computeCylinders($conf) {
		return $conf->getSize() / $conf->getBlockSize();
	}


}

?>
